<?php

require_once 'config.php';

function getLiveStream($streamId)
{
    if (!isset($streamId)) {
        echo "Missing 'streamId' parameter";
        return;
    }

    $jsonFilePath = "channels/live_playlist.json";
    $jsonContent = file_get_contents($jsonFilePath);
    $data = json_decode($jsonContent, true);

	$urlParam = '';
	$categoryId = '';

	foreach ($data as $item) {
		if (isset($item['stream_id']) && $item['stream_id'] == $streamId) {
			$urlParam = $item['video_url'];
			$categoryId = $item['category_id'];
			break;
		}
	}	
	
	if (stripos($urlParam, 'thetvapp.to') !== false)   {
		$urlparts = getTheTvAppStream($urlParam);
		header('Location: ' . $urlparts, true, 302);
		exit;
	}
	
	if (stripos($urlParam, 'DaddyLive|') !== false) {
		$parts = explode('|', $urlParam);
		
		if (count($parts) >= 3) {
			$data = [
				'url' => $parts[1],
				'ref' => $parts[2]
			];

			if ($data) {
				$base = locateBaseURL();        
				$urlparts = $base . 'hls_proxy.php?url=' . urlencode($data['url']) . '&data=' . base64_encode($data['ref']);
				header('Location: ' . $urlparts, true, 302);
			} else {
				header("HTTP/1.0 404 Not Found");
			}
		} else {
			header("HTTP/1.0 404 Not Found");
		}
		exit;
	}

	
    header('Location: ' . $urlParam, true, 302);
	exit;
}

//Daddy Live functions.
function getDaddyLiveSource($url) {
    $url = str_replace(["/cast/", "/stream/"], "/embed/", $url);
    
    $ch = curl_init($url);
    
    $headers = [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0',
        'Referer: https://dlhd.sx/'
    ];

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        return false;
    }

    preg_match('/<iframe src="([^"]+)"/', $response, $matches);
    if (!isset($matches[1])) {
        return false;
    }

    $iframe_src = $matches[1];
    
    $parsed_host = parse_url($iframe_src, PHP_URL_SCHEME) . '://' . parse_url($iframe_src, PHP_URL_HOST) . '/';
    
    $ch = curl_init($iframe_src);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    
    $response2 = curl_exec($ch);
    if (curl_errno($ch)) {
        return false;
    }

    preg_match('/(?<=source:\').*?\.m3u8(?=\')/', $response2, $matches);
    if (!isset($matches[0])) {
        return false;
    }

    $parsedUrl = $matches[0];
    
    return [
        'url' => $parsedUrl,
        'ref' => '|Referer="' . $parsed_host . '"'
    ];
}

//The TV App functions.
function getTheTvAppStream($url){
	
   $getHeaders = [
        "User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36",
        "Accept: */*", "Accept-Language: en-US,en;q=0.5",
        "X-Requested-With: XMLHttpRequest", "Origin: https://thetvapp.to",
        "Connection: keep-alive", "Referer: https://thetvapp.to"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $getHeaders);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_ENCODING, "");
    $response = curl_exec($ch);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $responseHeaders = substr($response, 0, $headerSize);
    $body = substr($response, $headerSize); //

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($httpCode === 200) {

        if (preg_match('/source:\s*"([^"]+)"/', $body, $matches)) {
            $fileUrl = $matches[1];
            header('Location: ' . $matches[1], true, 302);
            exit;
        }

        if (preg_match("/(?<=const encrypted = ').*?(?=')/", $body, $matches) &&
            preg_match('/(?<=modulepreload" href\=").*?js(?=")/', $body, $appurl)) {
            $defuscateString = $matches[0];
			
			//Try the stored key for decryption.
            $savedKey = @file_get_contents("TheTVApp_key.txt");
            if ($savedKey) {
                $decodedUrl = decryptString($savedKey, $defuscateString);
                if ($decodedUrl !== false && strpos($decodedUrl, 'thetvapp.to') !== false) {
                    header('Location: ' . $decodedUrl, true, 302);
                    exit;
                }
            }			

            $options = ['http' => ['method' => "GET", 'header' =>
                "Referer: https://thetvapp.to/\r\n" .
                "User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36\r\n"]];
            $context = stream_context_create($options);
            $content = @file_get_contents($appurl[0], false, $context);	

			
			//Get a new key.
            $key = findKey($content, $defuscateString);
            if (!$key) {
                echo "Couldn't find the decryption key";
                exit();
            }
			
			//Save the new key to file.
            file_put_contents("TheTVApp_key.txt", $key);
            $decodedUrl = decryptString($key, $defuscateString);

            if ($decodedUrl === false) {
                echo "Error in decryption";
                exit;
            }
			
			return $decodedUrl;

        }
    }
}	
	
function decryptString($key, $encString) {
    $l = base64_decode($encString);
    if ($l === false) {
        return false;
    }

    $o = '';
    for ($c = 0; $c < strlen($l); $c++) {
        $o .= chr(ord($l[$c]) ^ ord($key[$c % strlen($key)]));
    }
    return $o;
}

function findKey($data, $encString) {
            // Keys have been as low as 1 character in length.
            if (preg_match_all('/(?<=")[A-Z0-9a-z]{1,200}(?=")/', $data, $keyMatches)) {
                foreach ($keyMatches[0] as $i) {
                    $decodedEncString = base64_decode($encString, true);
                    if ($decodedEncString === false) {
                        
                        return false;
                    }
                    $o = '';
                    for ($c = 0; $c < strlen($decodedEncString); $c++) {
                        $o .= chr(ord($decodedEncString[$c]) ^ ord($i[$c % strlen($i)]));
                    }
                    // Check if the decoded string contains the specific substring
                    if (strpos($o, 'thetvapp.to') !== false) {
                       
                        return $i;
                    }
                }
            }
    
    return false;
}


getLiveStream($_GET['streamId']);


?>
