<?php

require_once 'config.php';
if (!$GLOBALS['DEBUG']) {
    error_reporting(0);	
} 	

function getPlutoTV($m3uContent) {
    $plutoM3uContent = @file_get_contents('https://i.mjh.nz/PlutoTV/us.m3u8');
    if (!$plutoM3uContent) {
        return false;
    }

    $lines = explode("\n", $plutoM3uContent);
    
    array_shift($lines);
	$newM3uContent ='';
    $streamId = 4000;

    $pattern = '/#EXTINF:-1 channel-id="([^"]*)" tvg-id="([^"]*)" tvg-logo="([^"]*)" tvg-chno="([^"]*)" group-title="([^"]*)"\s*,\s*(.*)/';

    for ($i = 0; $i < count($lines); $i++) {
        $line = $lines[$i];
        if (strpos($line, '#EXTINF:') === 0) {
            if (preg_match($pattern, $line, $matches)) {
                $channelUrl = $lines[$i + 1] ?? ''; 
				preg_match('/(?<=tvg-id=").*?(?=")/', $line, $tvgId);
				$channelName = iconv('UTF-8', 'ASCII//TRANSLIT', $matches[6]);
				$channelName = str_replace('"', "'", $channelName);

                $newM3uContent .= "#EXTINF:-1 tvg-id=\"{$tvgId[0]}\" tvg-name=\"{$channelName}\" tvg-logo=\"{$matches[3]}\" group-title=\"{$matches[5]} (PlutoTV)\" streamId=\"$streamId\" channel-number=\"$streamId\",{$channelName}\n";
                $newM3uContent .= $channelUrl . "\n\n";

                $streamId++;
            }
        }
    }
	
    if (empty($newM3uContent)) {
        $oldM3uContent = file_get_contents('channels/pluto_tv_data.dat');
		$m3uContent = str_replace('#[PLUTO_TV]#', "\n" . $oldM3uContent . "\n", $m3uContent);
    } else {
	$m3uContent = str_replace('#[PLUTO_TV]#', "\n" . $newM3uContent . "\n", $m3uContent);
		file_put_contents('channels/pluto_tv_data.dat', $newM3uContent);
    
	}
	
	return $m3uContent;
}


function getTheAppSports($m3uContent){
$urls = [
    "https://thetvapp.to/nba",
    "https://thetvapp.to/mlb",
	"https://thetvapp.to/nhl",
	"https://thetvapp.to/nfl",
	"https://thetvapp.to/ncaaf",
	"https://thetvapp.to/ncaab",
	"https://thetvapp.to/mls"
];

// Create multiple cURL handles
$multiCurl = curl_multi_init();
$curlHandles = array();

foreach ($urls as $i => $url) {
    $curlHandles[$i] = curl_init($url);
    curl_setopt($curlHandles[$i], CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curlHandles[$i], CURLOPT_FOLLOWLOCATION, true);
    curl_multi_add_handle($multiCurl, $curlHandles[$i]);
}

$running = null;
do {
    curl_multi_exec($multiCurl, $running);
} while ($running);

foreach ($curlHandles as $curlHandle) {
    curl_multi_remove_handle($multiCurl, $curlHandle);
}
curl_multi_close($multiCurl);

$sportsData = [];
$sportsDataM3u = '';
$sportsDataItems = [];
$channelId = 3000;

$epgData = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
$epgData .= '<tv>' . "\n";

foreach ($curlHandles as $handle) {
    $htmlContent = curl_multi_getcontent($handle);

    $doc = new DOMDocument();
    @$doc->loadHTML($htmlContent);
	
	
    foreach ($doc->getElementsByTagName('a') as $link) {
        
        if ($link->getAttribute('class') === 'list-group-item') {
			
            $href = $link->getAttribute('href');
            $text = trim($link->textContent);
            $time = '';

            // Extracting time span and removing it from text
            foreach ($link->getElementsByTagName('span') as $span) {
                $timeUTC = trim($span->textContent);

                // Convert to DateTime and adjust to EST
                $date = new DateTime($timeUTC);
                $date->setTimezone(new DateTimeZone('America/New_York')); // EST timezone

                // Format the date               
				$formattedDate = $date->format('h:i A T - (m/d/Y)');


                $time = $formattedDate; // Use formatted time

                // Remove the time from the text
                $text = str_replace($timeUTC, '', $text);
                $text = trim($text);
            }			

			$eventTime = DateTime::createFromFormat('h:i A T - (m/d/Y)', $formattedDate);
			$currentDateTime = new DateTime('now', new DateTimeZone('America/New_York'));

			// Extend the event time by 2 hours
			$extendedEventTime = clone $eventTime;
			$extendedEventTime->modify('+7200 seconds'); // Add 2 hours

			// Skip events that have already passed (considering the 2-hour extension)
			if ($extendedEventTime instanceof DateTime && $currentDateTime instanceof DateTime) {
				if ($extendedEventTime < $currentDateTime) {
					continue;
				} 
			}

			
			$tvgId = md5($text);
			$tvgId = substr($tvgId, 0, 10);
			$xmlText = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');

			
			date_default_timezone_set('America/New_York');
			$currentTime = new DateTime();
			$startTime = $currentTime->setTime(0, 0, 0);
			$endTime = clone $startTime;
			$endTime->modify('+28 hours'); // Used to keep the guide data populated.
			$startTimeFormatted = $startTime->format('YmdHis') . ' -0500';
			$endTimeFormatted = $endTime->format('YmdHis') . ' -0500';

			// Generating a random event ID
			$EventId = mt_rand(1000, 9999);			
			
			$epgData .= "<channel id=\"{$tvgId}\">\n";
			$epgData .= "\t<display-name lang=\"en\">{$xmlText} - {$time}</display-name>\n";
			$epgData .= "</channel>\n";

			$epgData .= "\t<programme channel=\"" . $tvgId . "\" start=\"" . $startTimeFormatted . "\" stop=\"" . $endTimeFormatted . "\">\n";
			$epgData .= "\t\t<title>" . $xmlText . " - " . $time . "</title>\n";
			$epgData .= "\t\t<desc>Description for " . $xmlText . " - " . $time . "</desc>\n";
			$epgData .= "\t</programme>\n";

            $fullUrl = 'https://thetvapp.to' . $href;
			
			$logo = null;
			
			if(stripos($href, 'nba')){
				$logo = 'https://raw.githubusercontent.com/tv-logo/tv-logos/635e715cb2f2c6d28e9691861d3d331dd040285b/countries/united-states/nba-tv-icon-us.png';
			}	
			
			if(stripos($href, 'mlb')){
				$logo = 'https://raw.githubusercontent.com/tv-logo/tv-logos/635e715cb2f2c6d28e9691861d3d331dd040285b/countries/united-states/mlb-network-us.png';
			}
			
			if(stripos($href, 'nhl')){
				$logo = 'https://raw.githubusercontent.com/tv-logo/tv-logos/635e715cb2f2c6d28e9691861d3d331dd040285b/countries/united-states/nhl-network-us.png';
			}
			
			if(stripos($href, 'nfl')){
				$logo = 'https://raw.githubusercontent.com/tv-logo/tv-logos/635e715cb2f2c6d28e9691861d3d331dd040285b/countries/united-states/nfl-icon-us.png';
			}
			
			if(stripos($href, 'ncaaf')){
				$logo = 'https://raw.githubusercontent.com/gogetta69/TMDB-To-VOD-Playlist/main/images/ncaaf-transparent.png';
			}

			if(stripos($href, 'ncaab')){
				$logo = 'https://raw.githubusercontent.com/gogetta69/TMDB-To-VOD-Playlist/main/images/ncaab-transparent.png';
			}				
			
			if(stripos($href, 'mls')){
				$logo = 'https://raw.githubusercontent.com/gogetta69/TMDB-To-VOD-Playlist/main/images/mls-transparent.png';
			}
			
			if($logo === null){
				$logo = 'https://raw.githubusercontent.com/gogetta69/TMDB-To-VOD-Playlist/main/images/live-tv-transparent.png';
			}			
			 
			$m3uLine = "#EXTINF:-1 tvg-id=\"{$tvgId}\" tvg-name=\"{$text} - {$time}\" tvg-logo=\"{$logo}\" group-title=\"Sports (TheTVApp)\" streamId=\"{$channelId}\" channel-number=\"{$channelId}\",{$text} - {$time}\n{$fullUrl}";
			
			$sportsDataItems[] = $m3uLine;			
			
			$channelId++;			

        }
    }  
}

$epgData .= '</tv>';

file_put_contents('channels/thetvapp_sports_epg.xml', $epgData);

if (!empty($sportsDataItems)) {
    
    $sportsDataM3u = '';
    foreach ($sportsDataItems as $index => $item) {
        $sportsDataM3u .= $item;
        if ($index < count($sportsDataItems) - 1) {
            $sportsDataM3u .= "\n\n";
        }
    }
    
    $m3uContent = str_replace('#[THETVAPP_SPORTS]#', "\n" . $sportsDataM3u . "\n", $m3uContent);
	
} else {
    
    $m3uContent = str_replace('#[THETVAPP_SPORTS]#', '', $m3uContent);
}

return $m3uContent;

}

function setupLiveStreams($m3uContent)
{		

    $baseUrl = locateBaseURL();
	$lastUpdatedFile = "channels/last_updated_channels.txt";
    $lines = explode("\n", $m3uContent);
    $parsedData = [];
	$num = 0;

	$groupTitleMapping = [];
	$categories = [];
	$groupNumber = 200; 

	foreach ($lines as $line) {
		if (strpos($line, '#EXTINF:') === 0) {
			preg_match('/group-title="([^"]*)"/', $line, $matches);
			if ($matches) {
				$groupTitle = $matches[1];
				if (!array_key_exists($groupTitle, $groupTitleMapping)) {
					
					$groupTitleMapping[$groupTitle] = $groupNumber;

					$categories[] = [
						"category_id" => (string)$groupNumber,
						"category_name" => $groupTitle,
						"parent_id" => 0
					];

					$groupNumber++;
				}
			}
		}
	}
	
	$parsedData = [];
	$num = 0;
	
	$daddyData = getDaddyLiveSource('https://dlhd.sx/stream/stream-303.php');

	for ($i = 0; $i < count($lines); $i++) {
		$line = $lines[$i];
		if (strpos($line, '#EXTINF:') === 0) {
			preg_match('/#EXTINF:-1 tvg-id="([^"]*)" tvg-name="([^"]*)" tvg-logo="([^"]*)" group-title="([^"]*)" streamId="([^"]*)" channel-number="([^"]*)",([^
	]*)/', $line, $matches);
			if ($matches) {
				$urlLine = $lines[$i + 1];
				$categoryTitle = $matches[4];
				$categoryId = array_key_exists($categoryTitle, $groupTitleMapping) ? $groupTitleMapping[$categoryTitle] : 0;
				$streamUrl = $baseUrl . 'live_play.php?streamId=' . (int)$matches[5];
				$m3uContent = str_replace($urlLine, $streamUrl, $m3uContent);
				if(stripos($urlLine, 'dlhd.sx')){
					$urlLine = 'DaddyLive|' . replaceDaddyLiveUrl($daddyData['url'], $urlLine) . $daddyData['ref'];;
				}				
				$parsedData[] = [
					'num' => (int)$num, 
					'name' => trim($matches[7]),
					'stream_type' => 'live', 
					'stream_id' => (int)$matches[5], 
					'stream_icon' => $matches[3],
					'epg_channel_id' => $matches[1], 
					'added' => time(), 
					'category_id' => $categoryId,
					'custom_sid' => '', 
					'tv_archive' => 0,					
					'direct_source' => $streamUrl,
					'tv_archive_duration' => 0,
					'video_url' => trim($urlLine),
				];
				$i++;
			}
			$num++;
		}
	}
	
	if (is_array($categories) && !empty($categories)) {	
		file_put_contents('channels/get_live_categories.json', json_encode($categories, JSON_PRETTY_PRINT));
	}
	
	if ($m3uContent) {	
		file_put_contents('channels/live_playlist.m3u8', $m3uContent);
	}

	if (is_array($parsedData) && !empty($parsedData)) {		
		file_put_contents($lastUpdatedFile, time());
		file_put_contents('channels/live_playlist.json', json_encode($parsedData, JSON_PRETTY_PRINT));
	}
	return $m3uContent;
}

function getDaddyLiveSource($url) {
    $url = str_replace(["/cast/", "/stream/"], "/embed/", $url);
    
    $ch = curl_init($url);
    
    $headers = [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0',
        'Referer: https://dlhd.sx/'
    ];

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        return false;
    }

    preg_match('/<iframe src="([^"]+)"/', $response, $matches);
    if (!isset($matches[1])) {
        return false;
    }

    $iframe_src = $matches[1];
    
    $parsed_host = parse_url($iframe_src, PHP_URL_SCHEME) . '://' . parse_url($iframe_src, PHP_URL_HOST) . '/';
    
    $ch = curl_init($iframe_src);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    
    $response2 = curl_exec($ch);
    if (curl_errno($ch)) {
        return false;
    }

    preg_match('/(?<=source:\').*?\.m3u8(?=\')/', $response2, $matches);
    if (!isset($matches[0])) {
        return false;
    }

    $parsedUrl = $matches[0];
    
    return [
        'url' => $parsedUrl,
        'ref' => '|Referer="' . $parsed_host . '"'
    ];
}

function replaceDaddyLiveUrl($originalString, $replacementSource) {
    // Extract digits from the replacement source that follow "-"
    preg_match('/stream-(\d+)/', $replacementSource, $replacementMatches);
    if (!empty($replacementMatches)) {
        $replacementDigits = $replacementMatches[1];

        // Extract the last sequence of digits in the original string before "/index.m3u8"
        preg_match('/\d+(?=\/index\.m3u8$)/', $originalString, $originalMatches);
        if (!empty($originalMatches)) {
            // Replace the digits in the original string
            return str_replace($originalMatches[0], $replacementDigits, $originalString);
        }
    }
    return $originalString;
}


function runLivePlaylistGenerate(){

$m3uContent = file_get_contents('channels/m3u_formatted.dat');

$baseUrl = locateBaseURL();
$m3uContent = str_replace('[XML_EPG]', $baseUrl . 'xmltv.php', $m3uContent);

$m3uAddSportsContent = getTheAppSports($m3uContent);

if ($m3uAddSportsContent) {
    $m3uContent = $m3uAddSportsContent;
}	

$m3uContent = getPlutoTV($m3uContent);
$m3uContent = setupLiveStreams($m3uContent);

return $m3uContent;

}

?>